@php
    $plan = Utility::getChatGPTSettings();
@endphp

{{ Form::open(['url' => 'transfer', 'method' => 'post']) }}
<div class="modal-body">

    @if ($plan->enable_chatgpt == 'on')
    <div class="card-footer text-end">
        <a href="#" class="btn btn-sm btn-primary" data-size="medium" data-ajax-popup-over="true"
            data-url="{{ route('generate', ['transfer']) }}" data-bs-toggle="tooltip" data-bs-placement="top"
            title="{{ __('Generate') }}" data-title="{{ __('Generate Content With AI') }}">
            <i class="fas fa-robot"></i>{{ __(' Generate With AI') }}
        </a>
    </div>
    @endif

    <div class="row">
        <div class="form-group col-lg-6 col-md-6">
            {{ Form::label('branch_id', __('Branch'), ['class' => 'col-form-label']) }}
            {{ Form::select('branch_id', $branches, null, ['class' => 'form-control select2 branch_id' , 'required' => 'required', 'id' => 'branch_id']) }}
        </div>
        <div class="form-group col-lg-6 col-md-6">
            {{-- {{ Form::label('department_id', __('Department'), ['class' => 'col-form-label']) }}
            <div class="department_div">
                {{ Form::select('department_id', $departments, null, ['class' => 'form-control select2 department_id' , 'required' => 'required']) }}
            </div> --}}

            <div class="form-icon-user" id="department_div">
                {{ Form::label('department', __('Department'), ['class' => 'col-form-label']) }}
                <select class="form-control select department_id" name="department_id"
                    id="department_id" placeholder="Select Department">
                </select>
            </div>

        </div>
        <div class="form-group col-lg-6 col-md-6">
            {{ Form::label('employee_id', __('Employee'), ['class' => 'col-form-label']) }}
            <div class="employee_div">
                {{ Form::select('employee_id', $employees, null, ['class' => 'form-control select2 employee_id' , 'required' => 'required']) }}
            </div>
        </div>
        <div class="form-group col-lg-6 col-md-6">
            {{ Form::label('transfer_date', __('Transfer Date'), ['class' => 'col-form-label']) }}
            {{ Form::text('transfer_date', null, ['class' => 'form-control d_week current_date', 'autocomplete' => 'off' , 'required' => 'required']) }}
        </div>
        <div class="form-group col-lg-12">
            {{ Form::label('description', __('Description'), ['class' => 'col-form-label']) }}
            {{ Form::textarea('description', null, ['class' => 'form-control', 'placeholder' => __('Enter Description'),'rows'=>'3' , 'required' => 'required']) }}
        </div>
    </div>
</div>
<div class="modal-footer">
    <input type="button" value="Cancel" class="btn btn-light" data-bs-dismiss="modal">
    <input type="submit" value="{{ __('Create') }}" class="btn btn-primary">
</div>

{{ Form::close() }}

<script>
    $(document).ready(function() {
        var now = new Date();
        var month = (now.getMonth() + 1);
        var day = now.getDate();
        if (month < 10) month = "0" + month;
        if (day < 10) day = "0" + day;
        var today = now.getFullYear() + '-' + month + '-' + day;
        $('.current_date').val(today);
    });
</script>