<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\Utility;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Password;

class PasswordResetLinkController extends Controller
{
    /**
     * Display the password reset link request view.
     *
     * @return \Illuminate\View\View
     */
    public function create()
    {
        return view('auth.forgot-password');
    }

    /**
     * Handle an incoming password reset link request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse
     *
     * @throws \Illuminate\Validation\ValidationException
     */
    public function store(Request $request)
    {
        $settings = Utility::settings();
        Artisan::call('optimize:clear');
        if(isset($settings['recaptcha_module']) && $settings['recaptcha_module'] == 'yes')
        {
            $validation['g-recaptcha-response'] = 'required';
        }else{
            $validation=[];
        }
        $this->validate($request, $validation);

        $request->validate([
            'email' => 'required|email',
        ]);

        // We will send the password reset link to this user. Once we have attempted
        // to send the link, we will examine the response then see the message we
        // need to show to the user. Finally, we'll send out a proper response.

        try{
            Utility::getSMTPDetails(1);
            $status = Password::sendResetLink(
                $request->only('email')
            );
            
            return $status == Password::RESET_LINK_SENT
                        ? back()->with('status', __($status))
                        : back()->withInput($request->only('email'))
                                ->withErrors(['email' => __($status)]);
        }
        catch(\Exception $e)
        {
            // return redirect()->back()->with('error', __('E-Mail has been not sent due to SMTP configuration'));            
            return redirect()->back()->withErrors('E-Mail has been not sent due to SMTP configuration');
            
        }     
    }
}
